/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine;

import de.sogomn.engine.IUpdatable;
import de.sogomn.engine.util.AbstractListenerContainer;

public final class Clock
extends AbstractListenerContainer<IUpdatable> {
    private long initialTime;
    private long lastTime;
    private long ticks;
    private static final double NANO_SECONDS_PER_SECOND = 1.0E9;

    public Clock() {
        this.reset();
    }

    public double update() {
        long now = System.nanoTime();
        double elapsed = (double)(System.nanoTime() - this.lastTime) / 1.0E9;
        this.notifyListeners(updatable -> updatable.update(elapsed));
        this.lastTime = now;
        ++this.ticks;
        return elapsed;
    }

    public void reset() {
        this.initialTime = this.lastTime = System.nanoTime();
        this.ticks = 0L;
    }

    public long tickCount() {
        return this.ticks;
    }

    public double elapsed() {
        double elapsed = (double)(System.nanoTime() - this.initialTime) / 1.0E9;
        return elapsed;
    }

    public double elapsedSinceLastUpdate() {
        double elapsed = (double)(System.nanoTime() - this.lastTime) / 1.0E9;
        return elapsed;
    }
}

