/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine;

import de.sogomn.engine.IMouseListener;
import de.sogomn.engine.util.AbstractListenerContainer;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

final class Mouse
extends AbstractListenerContainer<IMouseListener>
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private int offsetX = 0;
    private int offsetY = 0;
    private static final boolean PRESSED = true;
    private static final boolean RELEASED = false;
    private static final int NO_SCALE = 1;
    private static final int NO_OFFSET = 0;

    private int getRelativeX(int x) {
        int relativeX = (int)((float)x / this.scaleX - (float)this.offsetX / this.scaleX);
        return relativeX;
    }

    private int getRelativeY(int y) {
        int relativeY = (int)((float)y / this.scaleY - (float)this.offsetY / this.scaleY);
        return relativeY;
    }

    private void fireMouseEvent(MouseEvent m, boolean flag) {
        int x = this.getRelativeX(m.getX());
        int y = this.getRelativeY(m.getY());
        int button = m.getButton();
        this.notifyListeners(listener -> listener.mouseEvent(x, y, button, flag));
    }

    private void fireMouseMovedEvent(MouseEvent m) {
        int x = this.getRelativeX(m.getX());
        int y = this.getRelativeY(m.getY());
        int modifiers = m.getModifiers();
        this.notifyListeners(listener -> listener.mouseMotionEvent(x, y, modifiers));
    }

    private void fireMouseWheelEvent(MouseWheelEvent m) {
        int x = this.getRelativeX(m.getX());
        int y = this.getRelativeY(m.getY());
        int rotation = m.getWheelRotation();
        this.notifyListeners(listener -> listener.mouseWheelEvent(x, y, rotation));
    }

    @Override
    public void mousePressed(MouseEvent m) {
        this.fireMouseEvent(m, true);
    }

    @Override
    public void mouseReleased(MouseEvent m) {
        this.fireMouseEvent(m, false);
    }

    @Override
    public void mouseMoved(MouseEvent m) {
        this.fireMouseMovedEvent(m);
    }

    @Override
    public void mouseDragged(MouseEvent m) {
        this.fireMouseMovedEvent(m);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent m) {
        this.fireMouseWheelEvent(m);
    }

    @Override
    public void mouseClicked(MouseEvent m) {
    }

    @Override
    public void mouseEntered(MouseEvent m) {
    }

    @Override
    public void mouseExited(MouseEvent m) {
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void setOffset(int offsetX, int offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }
}

