/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.fx;

import de.sogomn.engine.fx.ISoundListener;
import de.sogomn.engine.util.AbstractListenerContainer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class Sound
extends AbstractListenerContainer<ISoundListener> {
    private byte[] data;
    private AudioFormat format;
    private SourceDataLine line;
    private boolean playing;
    private float gain;

    private Sound(byte[] data, AudioFormat format) {
        this.data = data;
        this.format = format;
    }

    private void writeDataToLine() {
        try {
            this.playing = true;
            this.line = AudioSystem.getSourceDataLine(this.format);
            if (this.line == null) {
                return;
            }
            this.line.open();
            FloatControl gainControl = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
            float minimum = gainControl.getMinimum();
            float maximum = gainControl.getMaximum();
            float actualGain = Math.max(minimum, Math.min(maximum, this.gain));
            gainControl.setValue(actualGain);
            this.line.start();
            this.line.write(this.data, 0, this.data.length);
            this.line.drain();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public synchronized void play(int loops) {
        Runnable runnable = () -> {
            int i = 0;
            while (i < loops) {
                this.writeDataToLine();
                if (!this.playing) break;
                this.notifyListeners(listener -> listener.looped(this));
                ++i;
            }
            this.notifyListeners(listener -> listener.stopped(this));
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized void play() {
        this.play(1);
    }

    public synchronized void stop() {
        if (this.line == null || !this.playing) {
            return;
        }
        this.playing = false;
        this.line.stop();
        this.line.flush();
        this.line.close();
        this.line = null;
    }

    public void setGain(float gain) {
        this.gain = gain;
    }

    public void setSampleRate(float sampleRate) {
        AudioFormat newFormat;
        this.format = newFormat = new AudioFormat(this.format.getEncoding(), sampleRate, this.format.getSampleSizeInBits(), this.format.getChannels(), this.format.getFrameSize(), this.format.getFrameRate(), this.format.isBigEndian(), this.format.properties());
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public float getGain() {
        return this.gain;
    }

    public float getSampleRate() {
        return this.format.getSampleRate();
    }

    public static Sound loadSound(byte[] data) {
        Sound sound = new Sound(data, null);
        return sound;
    }

    public static Sound loadSound(String path) {
        try {
            BufferedInputStream bufferedIn = new BufferedInputStream(Sound.class.getResourceAsStream(path));
            AudioInputStream in = AudioSystem.getAudioInputStream(bufferedIn);
            AudioFormat format = in.getFormat();
            int bufferSize = in.available();
            byte[] buffer = new byte[bufferSize];
            in.read(buffer, 0, bufferSize);
            Sound sound = new Sound(buffer, format);
            return sound;
        }
        catch (IOException | UnsupportedAudioFileException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Sound loadExternalSound(File file) {
        try {
            AudioInputStream in = AudioSystem.getAudioInputStream(file);
            int bufferSize = in.available();
            byte[] buffer = new byte[bufferSize];
            AudioFormat format = in.getFormat();
            in.read(buffer, 0, bufferSize);
            Sound sound = new Sound(buffer, format);
            return sound;
        }
        catch (IOException | UnsupportedAudioFileException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Sound loadExternalSound(String path) {
        File file = new File(path);
        Sound sound = Sound.loadExternalSound(file);
        return sound;
    }
}

