/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.fx;

import de.sogomn.engine.util.ImageUtils;
import java.awt.image.BufferedImage;

public final class SpriteSheet {
    private BufferedImage[][] sprites;
    private int width;
    private int height;
    private int spriteWidth;
    private int spriteHeight;
    private int spritesWide;
    private int spritesHigh;

    public SpriteSheet(BufferedImage image, int spriteWidth, int spriteHeight) {
        this.spriteWidth = spriteWidth;
        this.spriteHeight = spriteHeight;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.spritesWide = this.width / spriteWidth;
        this.spritesHigh = this.height / spriteHeight;
        this.sprites = new BufferedImage[this.spritesWide][this.spritesHigh];
        this.loadSprites(image);
    }

    public SpriteSheet(String path, int spriteWidth, int spriteHeight) {
        this(ImageUtils.loadImage(path), spriteWidth, spriteHeight);
    }

    private void loadSprites(BufferedImage image) {
        int x = 0;
        while (x < this.spritesWide) {
            int y = 0;
            while (y < this.spritesHigh) {
                BufferedImage subimage;
                int imageX = x * this.spriteWidth;
                int imageY = y * this.spriteHeight;
                this.sprites[x][y] = subimage = image.getSubimage(imageX, imageY, this.spriteWidth, this.spriteHeight);
                ++y;
            }
            ++x;
        }
    }

    public BufferedImage getSprite(int x, int y) {
        if (x < 0 || y < 0 || x > this.spritesWide - 1 || y > this.spritesHigh - 1) {
            return null;
        }
        BufferedImage image = this.sprites[x][y];
        return image;
    }

    public BufferedImage getSprite(int index, Orientation orientation) {
        int x = 0;
        int y = 0;
        if (orientation == Orientation.LEFT_TO_RIGHT) {
            x = index % this.spritesWide;
            y = index / this.spritesWide;
        } else if (orientation == Orientation.TOP_TO_BOTTOM) {
            x = index / this.spritesWide;
            y = index % this.spritesWide;
        }
        BufferedImage image = this.getSprite(x, y);
        return image;
    }

    public BufferedImage getSprite(int index) {
        BufferedImage image = this.getSprite(index, Orientation.LEFT_TO_RIGHT);
        return image;
    }

    public BufferedImage[] getSprites(Orientation orientation, int ... indices) {
        int length = indices.length;
        BufferedImage[] images = new BufferedImage[length];
        int i = 0;
        while (i < length) {
            int index = indices[i];
            images[i] = this.getSprite(index, orientation);
            ++i;
        }
        return images;
    }

    public BufferedImage[] getSprites(int ... indices) {
        return this.getSprites(Orientation.LEFT_TO_RIGHT, indices);
    }

    public BufferedImage[] getSprites() {
        BufferedImage[] images = new BufferedImage[this.spritesWide * this.spritesHigh];
        int x = 0;
        while (x < this.spritesWide) {
            int y = 0;
            while (y < this.spritesHigh) {
                BufferedImage image = this.getSprite(x, y);
                int index = x + y * this.spritesWide;
                images[index] = image;
                ++y;
            }
            ++x;
        }
        return images;
    }

    public int getSpriteWidth() {
        return this.spriteWidth;
    }

    public int getSpriteHeight() {
        return this.spriteHeight;
    }

    public int getSpritesWide() {
        return this.spritesWide;
    }

    public int getSpritesHigh() {
        return this.spritesHigh;
    }

    public static enum Orientation {
        LEFT_TO_RIGHT,
        TOP_TO_BOTTOM;

    }
}

