/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.gui;

import de.sogomn.engine.IDrawable;
import de.sogomn.engine.IKeyboardListener;
import de.sogomn.engine.IMouseListener;

public abstract class AbstractGuiComponent
implements IDrawable,
IMouseListener,
IKeyboardListener {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean hovered;
    protected boolean focused;
    protected boolean leftPressed;
    protected boolean middlePressed;
    protected boolean rightPressed;

    public AbstractGuiComponent(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    protected abstract void clicked(int var1);

    protected abstract void scrolled(int var1);

    protected abstract void typed(int var1);

    @Override
    public final void mouseEvent(int x, int y, int button, boolean flag) {
        boolean clicked;
        boolean bl = clicked = (this.leftPressed || this.rightPressed) && !flag && this.hovered;
        if (clicked) {
            this.clicked(button);
        }
        if (button == 1) {
            boolean bl2 = this.leftPressed = this.hovered && flag;
            if (!flag) {
                this.focused = this.hovered;
            }
        } else if (button == 2) {
            this.middlePressed = this.hovered && flag;
        } else if (button == 3) {
            this.rightPressed = this.hovered && flag;
        }
    }

    @Override
    public final void mouseMotionEvent(int x, int y, int modifiers) {
        this.hovered = this.contains(x, y);
    }

    @Override
    public final void mouseWheelEvent(int x, int y, int rotation) {
        if (this.hovered) {
            this.scrolled(rotation);
        }
    }

    @Override
    public final void keyboardEvent(int key, boolean flag) {
        if (this.focused && flag) {
            this.typed(key);
        }
    }

    public boolean contains(int xPos, int yPos) {
        boolean contains = xPos > this.x && xPos < this.x + this.width && yPos > this.y && yPos < this.y + this.height;
        return contains;
    }

    public final void setX(int x) {
        this.x = x;
    }

    public final void setY(int y) {
        this.y = y;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final void setHeight(int height) {
        this.height = height;
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final boolean isHovered() {
        return this.hovered;
    }

    public final boolean isFocused() {
        return this.focused;
    }

    public final boolean isLeftPressed() {
        return this.leftPressed;
    }

    public final boolean isMiddlePressed() {
        return this.middlePressed;
    }

    public final boolean isRightPressed() {
        return this.rightPressed;
    }
}

