/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.util;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class FileUtils {
    private static final int BUFFER_SIZE = 1024;

    private FileUtils() {
    }

    public static byte[] readInternalData(String path) {
        InputStream in = FileUtils.class.getResourceAsStream(path);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        try {
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        return out.toByteArray();
    }

    public static byte[] readExternalData(String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            byte[] data = Files.readAllBytes(file);
            return data;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String[] readInternalLines(String path) {
        InputStream in = FileUtils.class.getResourceAsStream(path);
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        String[] lineArray = (String[])lines.stream().toArray(String[]::new);
        return lineArray;
    }

    public static String[] readExternalLines(String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            List<String> lines = Files.readAllLines(file);
            String[] lineArray = (String[])lines.stream().toArray(String[]::new);
            return lineArray;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static boolean writeData(String path, byte[] data) {
        Path file = Paths.get(path, new String[0]);
        try {
            Files.write(file, data, new OpenOption[0]);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean writeLines(String path, String ... lines) {
        Path file = Paths.get(path, new String[0]);
        List<String> lineList = Arrays.asList(lines);
        try {
            Files.write(file, lineList, new OpenOption[0]);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean createFile(String path) {
        Path file = Paths.get(path, new String[0]);
        Path parent = file.getParent();
        try {
            Files.createDirectories(parent, new FileAttribute[0]);
            Files.createFile(file, new FileAttribute[0]);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean deleteFile(String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            Files.delete(file);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean createDirectory(String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            Files.createDirectories(file, new FileAttribute[0]);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean copyFile(Path source, Path destination) {
        try {
            Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean copyFile(String source, String destination) {
        Path sourceFile = Paths.get(source, new String[0]);
        Path destinationFile = Paths.get(destination, new String[0]);
        return FileUtils.copyFile(sourceFile, destinationFile);
    }

    public static boolean executeFile(File file) {
        Desktop desktop;
        boolean canOpen;
        boolean desktopSupported = Desktop.isDesktopSupported();
        if (desktopSupported && file.exists() && (canOpen = (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.OPEN))) {
            try {
                desktop.open(file);
                return true;
            }
            catch (IOException ex) {
                return false;
            }
        }
        return false;
    }

    public static boolean executeFile(String path) {
        File file = new File(path);
        return FileUtils.executeFile(file);
    }
}

