/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.engine.util;

public strictfp final class Vector2D {
    private double x;
    private double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vector2D() {
        this(0.0, 0.0);
    }

    public Vector2D(double value) {
        this(value, value);
    }

    public String toString() {
        String string = "[" + this.x + " | " + this.y + "] - Length: " + this.length();
        return string;
    }

    public double dot(Vector2D other) {
        return Vector2D.dot(this, other);
    }

    public Vector2D rotate(double degrees) {
        return Vector2D.rotate(this, degrees);
    }

    public Vector2D normalize() {
        return Vector2D.normalize(this);
    }

    public double length() {
        return Vector2D.length(this);
    }

    public Vector2D distance(Vector2D other) {
        return Vector2D.distance(this, other);
    }

    public void addX(double x) {
        this.x += x;
    }

    public void addY(double y) {
        this.y += y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void set(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public static double dot(Vector2D one, Vector2D two) {
        double value = one.x * two.x + one.y * two.y;
        return value;
    }

    public static Vector2D rotate(Vector2D vector, double degrees) {
        double radians = Math.toRadians(degrees);
        double newX = vector.x * Math.cos(radians) - vector.y * Math.sin(radians);
        double newY = vector.y * Math.cos(radians) + vector.x * Math.sin(radians);
        Vector2D result = new Vector2D(newX, newY);
        return result;
    }

    public static Vector2D normalize(Vector2D vector) {
        double length = Vector2D.length(vector);
        double newX = vector.x / length;
        double newY = vector.y / length;
        Vector2D result = new Vector2D(newX, newY);
        return result;
    }

    public static double length(Vector2D vector) {
        double length = Math.sqrt(vector.x * vector.x + vector.y * vector.y);
        return length;
    }

    public static Vector2D distance(Vector2D one, Vector2D two) {
        double distanceX = two.x - one.x;
        double distanceY = two.y - one.y;
        Vector2D distance = new Vector2D(distanceX, distanceY);
        return distance;
    }
}

