/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;

public final class PingPacket
extends AbstractPingPongPacket {
    private long milliseconds;

    public PingPacket() {
        this.type = 0;
    }

    @Override
    protected void sendRequest(ActiveConnection connection) {
        long time = System.currentTimeMillis();
        connection.writeLong(time);
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        connection.writeLong(this.milliseconds);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
        this.milliseconds = connection.readLong();
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        this.milliseconds = System.currentTimeMillis() - connection.readLong();
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
        this.type = 1;
        connection.addPacket(this);
    }

    @Override
    protected void executeData(ActiveConnection connection) {
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }
}

