/*
 * Decompiled with CFR 0.152.
 */
package org.jnativehook;

import java.io.File;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.jnativehook.DefaultDispatchService;
import org.jnativehook.NativeHookException;
import org.jnativehook.NativeInputEvent;
import org.jnativehook.NativeLibraryLocator;
import org.jnativehook.keyboard.NativeKeyEvent;
import org.jnativehook.keyboard.NativeKeyListener;
import org.jnativehook.mouse.NativeMouseEvent;
import org.jnativehook.mouse.NativeMouseListener;
import org.jnativehook.mouse.NativeMouseMotionListener;
import org.jnativehook.mouse.NativeMouseWheelEvent;
import org.jnativehook.mouse.NativeMouseWheelListener;

public final class GlobalScreen {
    private static Logger log = Logger.getLogger(GlobalScreen.class.getPackage().getName());
    private static NativeHookThread hookThread;
    private static ExecutorService eventExecutor;
    private static EventListenerList eventListeners;

    private GlobalScreen() {
    }

    public static void addNativeKeyListener(NativeKeyListener nativeKeyListener) {
        if (nativeKeyListener != null) {
            eventListeners.add(NativeKeyListener.class, nativeKeyListener);
        }
    }

    public static void removeNativeKeyListener(NativeKeyListener nativeKeyListener) {
        if (nativeKeyListener != null) {
            eventListeners.remove(NativeKeyListener.class, nativeKeyListener);
        }
    }

    public static void addNativeMouseListener(NativeMouseListener nativeMouseListener) {
        if (nativeMouseListener != null) {
            eventListeners.add(NativeMouseListener.class, nativeMouseListener);
        }
    }

    public static void removeNativeMouseListener(NativeMouseListener nativeMouseListener) {
        if (nativeMouseListener != null) {
            eventListeners.remove(NativeMouseListener.class, nativeMouseListener);
        }
    }

    public static void addNativeMouseMotionListener(NativeMouseMotionListener nativeMouseMotionListener) {
        if (nativeMouseMotionListener != null) {
            eventListeners.add(NativeMouseMotionListener.class, nativeMouseMotionListener);
        }
    }

    public static void removeNativeMouseMotionListener(NativeMouseMotionListener nativeMouseMotionListener) {
        if (nativeMouseMotionListener != null) {
            eventListeners.remove(NativeMouseMotionListener.class, nativeMouseMotionListener);
        }
    }

    public static void addNativeMouseWheelListener(NativeMouseWheelListener nativeMouseWheelListener) {
        if (nativeMouseWheelListener != null) {
            eventListeners.add(NativeMouseWheelListener.class, nativeMouseWheelListener);
        }
    }

    public static void removeNativeMouseWheelListener(NativeMouseWheelListener nativeMouseWheelListener) {
        if (nativeMouseWheelListener != null) {
            eventListeners.remove(NativeMouseWheelListener.class, nativeMouseWheelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerNativeHook() throws NativeHookException {
        if (hookThread == null || !hookThread.isAlive()) {
            NativeHookThread nativeHookThread = hookThread = new NativeHookThread();
            synchronized (nativeHookThread) {
                hookThread.start();
                try {
                    hookThread.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new NativeHookException(interruptedException);
                }
                NativeHookException nativeHookException = hookThread.getException();
                if (nativeHookException != null) {
                    throw nativeHookException;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterNativeHook() throws NativeHookException {
        if (GlobalScreen.isNativeHookRegistered()) {
            NativeHookThread nativeHookThread = hookThread;
            synchronized (nativeHookThread) {
                hookThread.disable();
                try {
                    hookThread.join();
                }
                catch (InterruptedException interruptedException) {
                    throw new NativeHookException(interruptedException.getCause());
                }
            }
        }
    }

    public static boolean isNativeHookRegistered() {
        return hookThread != null && hookThread.isAlive();
    }

    public static native void postNativeEvent(NativeInputEvent var0);

    public static void dispatchEvent(NativeInputEvent nativeInputEvent) {
        if (eventExecutor != null) {
            eventExecutor.execute(new EventDispatchTask(nativeInputEvent));
        }
    }

    public static void setEventDispatcher(ExecutorService executorService) {
        if (eventExecutor != null) {
            eventExecutor.shutdown();
        }
        eventExecutor = executorService;
    }

    static {
        eventExecutor = new DefaultDispatchService();
        eventListeners = new EventListenerList();
        String string = System.getProperty("jnativehook.lib.name", "JNativeHook");
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string2 = System.getProperty("jnativehook.lib.locator", "org.jnativehook.DefaultLibraryLocator");
            try {
                NativeLibraryLocator nativeLibraryLocator = Class.forName(string2).asSubclass(NativeLibraryLocator.class).newInstance();
                Iterator<File> iterator = nativeLibraryLocator.getLibraries();
                while (iterator.hasNext()) {
                    File file = iterator.next();
                    if (!file.exists() || !file.isFile() || !file.canRead()) continue;
                    System.load(file.getPath());
                }
            }
            catch (Exception exception) {
                log.severe(exception.getMessage());
                throw new UnsatisfiedLinkError(exception.getMessage());
            }
        }
    }

    private static class EventDispatchTask
    implements Runnable {
        private NativeInputEvent event;

        public EventDispatchTask(NativeInputEvent nativeInputEvent) {
            this.event = nativeInputEvent;
        }

        public void run() {
            if (this.event instanceof NativeKeyEvent) {
                this.processKeyEvent((NativeKeyEvent)this.event);
            } else if (this.event instanceof NativeMouseWheelEvent) {
                this.processMouseWheelEvent((NativeMouseWheelEvent)this.event);
            } else if (this.event instanceof NativeMouseEvent) {
                switch (this.event.getID()) {
                    case 2500: 
                    case 2501: 
                    case 2502: {
                        this.processButtonEvent((NativeMouseEvent)this.event);
                        break;
                    }
                    case 2503: 
                    case 2504: {
                        this.processMouseEvent((NativeMouseEvent)this.event);
                    }
                }
            } else if (this.event instanceof NativeMouseWheelEvent) {
                this.processMouseWheelEvent((NativeMouseWheelEvent)this.event);
            }
        }

        private void processKeyEvent(NativeKeyEvent nativeKeyEvent) {
            NativeKeyListener[] nativeKeyListenerArray = (NativeKeyListener[])eventListeners.getListeners(NativeKeyListener.class);
            switch (nativeKeyEvent.getID()) {
                case 2401: {
                    for (int i = 0; i < nativeKeyListenerArray.length; ++i) {
                        nativeKeyListenerArray[i].nativeKeyPressed(nativeKeyEvent);
                    }
                    break;
                }
                case 2400: {
                    for (int i = 0; i < nativeKeyListenerArray.length; ++i) {
                        nativeKeyListenerArray[i].nativeKeyTyped(nativeKeyEvent);
                    }
                    break;
                }
                case 2402: {
                    for (int i = 0; i < nativeKeyListenerArray.length; ++i) {
                        nativeKeyListenerArray[i].nativeKeyReleased(nativeKeyEvent);
                    }
                    break;
                }
            }
        }

        private void processButtonEvent(NativeMouseEvent nativeMouseEvent) {
            NativeMouseListener[] nativeMouseListenerArray = (NativeMouseListener[])eventListeners.getListeners(NativeMouseListener.class);
            switch (nativeMouseEvent.getID()) {
                case 2500: {
                    for (int i = 0; i < nativeMouseListenerArray.length; ++i) {
                        nativeMouseListenerArray[i].nativeMouseClicked(nativeMouseEvent);
                    }
                    break;
                }
                case 2501: {
                    for (int i = 0; i < nativeMouseListenerArray.length; ++i) {
                        nativeMouseListenerArray[i].nativeMousePressed(nativeMouseEvent);
                    }
                    break;
                }
                case 2502: {
                    for (int i = 0; i < nativeMouseListenerArray.length; ++i) {
                        nativeMouseListenerArray[i].nativeMouseReleased(nativeMouseEvent);
                    }
                    break;
                }
            }
        }

        private void processMouseEvent(NativeMouseEvent nativeMouseEvent) {
            NativeMouseMotionListener[] nativeMouseMotionListenerArray = (NativeMouseMotionListener[])eventListeners.getListeners(NativeMouseMotionListener.class);
            switch (nativeMouseEvent.getID()) {
                case 2503: {
                    for (int i = 0; i < nativeMouseMotionListenerArray.length; ++i) {
                        nativeMouseMotionListenerArray[i].nativeMouseMoved(nativeMouseEvent);
                    }
                    break;
                }
                case 2504: {
                    for (int i = 0; i < nativeMouseMotionListenerArray.length; ++i) {
                        nativeMouseMotionListenerArray[i].nativeMouseDragged(nativeMouseEvent);
                    }
                    break;
                }
            }
        }

        private void processMouseWheelEvent(NativeMouseWheelEvent nativeMouseWheelEvent) {
            NativeMouseWheelListener[] nativeMouseWheelListenerArray = (NativeMouseWheelListener[])eventListeners.getListeners(NativeMouseWheelListener.class);
            for (int i = 0; i < nativeMouseWheelListenerArray.length; ++i) {
                nativeMouseWheelListenerArray[i].nativeMouseWheelMoved(nativeMouseWheelEvent);
            }
        }
    }

    private static class NativeHookThread
    extends Thread {
        private NativeHookException exception;

        public NativeHookThread() {
            this.setName("JNativeHook Hook Thread");
            this.setDaemon(false);
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.exception = null;
            try {
                this.enable();
            }
            catch (NativeHookException nativeHookException) {
                this.exception = nativeHookException;
            }
            NativeHookThread nativeHookThread = this;
            synchronized (nativeHookThread) {
                this.notifyAll();
            }
        }

        public NativeHookException getException() {
            return this.exception;
        }

        private native void enable() throws NativeHookException;

        public native void disable() throws NativeHookException;
    }
}

